//
//  CMS_Strings_Test.m
//  Composr Mobile SDK
//
//  Created by Aaswini on 07/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
import XCTest
class CMS_Strings_Test: XCTestCase {


    func setUp() {
        super.setUp()
        // Put setup code here. This method is called before the invocation of each test method in the class.
    }

    func tearDown() {
        // Put teardown code here. This method is called after the invocation of each test method in the class.
        super.tearDown()
    }

    func test_strip_tags() {
        var inputString = "<html><head><title>Title</title></head><body>My test</br>html Page</body></html>"
        var expectedOutput = "TitleMy testhtml Page"
        XCTAssertTrue((CMS_Strings.strip_tags(inputString) == expectedOutput), "")
    }

    func test_html_entity_decode() {
        var inputString = "&ldquo;I love cats &amp; dogs&ldquo;"
        var expectedOutput = "“I love cats & dogs“"
        XCTAssertTrue((CMS_Strings.html_entity_decode(inputString) == expectedOutput), "")
    }

    func test_float_format() {
        var input: Double = 12345678.012110
        XCTAssertTrue((CMS_Strings.float_format(input, 0, false) == "12,345,678.01211"), "")
        XCTAssertTrue((CMS_Strings.float_format(input, 0, true) == "12,345,678"), "")
        XCTAssertTrue((CMS_Strings.float_format(input, 2, true) == "12,345,678.01"), "")
    }

    func test_strpos() {
        var inputString = "I love cats and dogs"
        XCTAssertEqual(CMS_Strings.strpos(inputString, "love"), 2, "")
        XCTAssertEqual(CMS_Strings.strpos(inputString, "s"), 10, "")
    }

    func test_str_replace() {
        var inputString = "I love cats and dogs"
        var expectedOutput = "I love cats and birds"
        XCTAssertTrue((CMS_Strings.str_replace("dogs", "birds", inputString) == expectedOutput), "")
    }

    func test_substr() {
        var inputString = "I love cats and dogs"
        var expectedOutput = "and dogs"
        XCTAssertTrue((CMS_Strings.substr(inputString, 12, 8) == expectedOutput), "")
    }

    func test_trim() {
        var inputString = "   I love cats and dogs     \n \r \t  "
        var expectedOutput = "I love cats and dogs"
        XCTAssertTrue((CMS_Strings.trim(inputString) == expectedOutput), "")
    }

    func test_strlen() {
        var inputString = "   I love cats and dogs     \n \r \t  "
        XCTAssertTrue(CMS_Strings.strlen(inputString) == 35)
        XCTAssertFalse(CMS_Strings.strlen(inputString) == 38)
        XCTAssertTrue(CMS_Strings.strlen(nil) == 0)
    }

    func test_stringWithFormat() {
        var inputString = "I like %@ and %@."
        var arguments = ["cats", "dogs"]
        var expectedOutput = "I like cats and dogs."
        var output = CMS_Strings.stringWithFormat(inputString, array: arguments)
        XCTAssertTrue((expectedOutput == output), "This is not what I expected.")
    }
}